/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8275;

import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.eui.JDMWizardInfo;
import ibm.nways.jdm.eui.JDMWizardPanelDelegate;
import ibm.nways.jdm.eui.MessageBox;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm8275.BoxInfo;
import ibm.nways.ras.RAS;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;

public class UnicastAddrDelete
implements JDMWizardPanelDelegate {
    private static ResourceBundle myResources = ResourceBundle.getBundle("ibm.nways.jdm8275.GeneralResources");
    public static final int RASID = 19;
    public static final int RASSUB = 7;
    DestinationPropBook myBook;
    JdmBrowser browser;
    NavigationContext myContext;
    BoxInfo boxInfo;
    MessageBox messageToUser;
    boolean noErrors = true;
    Serializable macAddress;
    Serializable vlanId;
    Serializable portNum;
    Serializable securityMode;
    String errorMsg;
    boolean loggingOn = false;

    public void setDefaults(JDMWizardInfo jDMWizardInfo) {
        String string = "setDefaults";
        if (RAS.isEnabled(19, 7)) {
            RAS.enter(19, 7, this, string);
        }
        this.myBook = (DestinationPropBook)jDMWizardInfo.getPropertyBook();
        if (this.browser == null && this.myBook != null) {
            this.browser = (JdmBrowser)this.myBook.getBrowser();
        }
        ModelInfo modelInfo = jDMWizardInfo.getCurrentRow();
        Hashtable hashtable = jDMWizardInfo.getItems();
        if (modelInfo == null) {
            if (RAS.isEnabled(19, 7)) {
                RAS.trace(19, 7, this, string, "empty Row");
            }
            this.errorMsg = new String("WZ_emptyRow");
            this.noErrors = false;
            this.browser.displayMsg(UnicastAddrDelete.getNLSString(this.errorMsg));
            this.messageToUser = new MessageBox(this.browser.getFrame(), UnicastAddrDelete.getNLSString("UD_error"), UnicastAddrDelete.getNLSString(this.errorMsg), true);
        } else {
            this.vlanId = modelInfo.get("Index.VlanIdNum");
            this.macAddress = modelInfo.get("Index.MacAddr");
            this.portNum = modelInfo.get("Panel.UnicastAddrPortNum");
            hashtable.put("deleteMacAddr", this.macAddress);
            hashtable.put("deleteVlanIdNum", this.vlanId);
            hashtable.put("deletePort", this.portNum);
            this.browser.displayMsg(UnicastAddrDelete.getNLSString("WZ_deleteConfirm"));
        }
        if (RAS.isEnabled(19, 7)) {
            RAS.exit(19, 7, this, string);
        }
    }

    public boolean abort(JDMWizardInfo jDMWizardInfo) {
        return true;
    }

    public boolean proceed(JDMWizardInfo jDMWizardInfo) {
        GenModel genModel = null;
        ModelInfo modelInfo = null;
        String string = "proceed";
        if (RAS.isEnabled(19, 7)) {
            RAS.enter(19, 7, this, string);
        }
        this.myBook = (DestinationPropBook)jDMWizardInfo.getPropertyBook();
        if (this.browser == null && this.myBook != null) {
            this.browser = (JdmBrowser)this.myBook.getBrowser();
        }
        if (this.browser == null) {
            if (RAS.isEnabled(19, 7)) {
                RAS.trace(19, 7, this, string, "Can't get browser- can't proceed with delete");
            }
            this.noErrors = false;
        }
        if (this.noErrors) {
            genModel = jDMWizardInfo.getModel();
            modelInfo = new ModelInfo();
            modelInfo.add("Index.MacAddr", this.macAddress);
            modelInfo.add("Index.VlanIdNum", this.vlanId);
            modelInfo.add("Panel.PhonyAdminStatus", new Integer(3));
            try {
                modelInfo = genModel.setInfo("Panel", modelInfo);
                this.noErrors = this.checkSnmpResponse(modelInfo);
                if (!this.noErrors) {
                    this.errorMsg = new String("WZ_badSet");
                }
            }
            catch (Exception exception) {
                this.noErrors = false;
                this.errorMsg = new String("WZ_badSet");
                if (RAS.isEnabled(19, 7)) {
                    RAS.trace(19, 7, this, string, "Exception setting unicast delete");
                }
                RAS.logException(19, 7, this, string, exception);
            }
        }
        if (!this.noErrors && this.browser != null) {
            this.browser.displayMsg(UnicastAddrDelete.getNLSString(this.errorMsg));
            this.messageToUser = new MessageBox(this.browser.getFrame(), UnicastAddrDelete.getNLSString("UD_error"), UnicastAddrDelete.getNLSString(this.errorMsg), true);
        }
        if (RAS.isEnabled(19, 7)) {
            RAS.exit(19, 7, this, string);
        }
        return this.noErrors;
    }

    protected static String getNLSString(String string) {
        String string2 = null;
        try {
            string2 = myResources.getString(string);
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }

    private boolean checkSnmpResponse(ModelInfo modelInfo) {
        boolean bl = false;
        Enumeration enumeration = modelInfo.getItemIds();
        while (enumeration.hasMoreElements()) {
            bl = true;
            String string = (String)enumeration.nextElement();
            Serializable serializable = modelInfo.get(string);
            if (!(serializable instanceof SpecialValue)) continue;
            if (RAS.isEnabled(19, 7)) {
                RAS.trace(19, 7, this, "checkSnmpResponse", "Error in snmp set. Variable is " + string + "  SpecialValue is " + serializable);
            }
            bl = false;
            break;
        }
        return bl;
    }
}

